# @summary Installs limnoria
#
class limnoria::install (
  Enum['present', 'absent'] $ensure = $limnoria::ensure,
  String[1] $username = $limnoria::username,
  Stdlib::AbsolutePath $home = $limnoria::home,
) {
  group { 'limnoria':
    ensure => $ensure,
    name   => $username,
    system => true,
  }
  user { 'limnoria':
    ensure     => $ensure,
    name       => $username,
    gid        => $username,
    home       => $home,
    managehome => true,
    system     => true,
  }

  package { 'limnoria':
    ensure => $ensure,
  }

  Group['limnoria']
  -> User['limnoria']
  -> Package['limnoria']
}
