# @summary Configure a node to run limnoria instances
#
# @example Define an instance in hieradata
#   limnoria::instances:
#     test:
#       nickname: testbot
#       channels:
#         - '#koumbit-ct'
#       users:
#         1:
#           name: myircnickname
#           password: "%{hiera('trocla_lookup::plain::xxx')}"
#
#
class limnoria (
  Enum['present', 'absent'] $ensure = 'present',
  String[1] $username = 'supybot',
  Stdlib::AbsolutePath $home = "/var/lib/${username}",
  Hash[String, Hash] $instances = {},
) {

  include limnoria::install
  $instances.each | $name, $data | {
    # An ensure in $data will override the global ensure
    $_data = {'ensure' => $ensure} + $data
    limnoria::instance { $name:
      * => $_data,
    }
  }
}
